﻿//////////////////////////////////////////////
// JpgHuffmanTable.h
//
//////////////////////////////////////////////

/// Defines / Macros -------------------------

#pragma once

/// Includes ---------------------------------

// nkMemory
#include <NilkinsMemory/Containers/BufferView.h>

// Standards
#include <array>
#include <vector>

/// Class ------------------------------------

namespace nkImages::jpg
{
	class JpgHuffmanTable final
	{
		public :

			// Functions
			// Writing
			static unsigned int getMarkerSpotByteSize (nkMemory::BufferView<const unsigned char> table, const std::array<unsigned char, 16>& perBitsCount, bool writeMarkers) ;
			static void writeMarker (unsigned char* out, unsigned char tableIndex, nkMemory::BufferView<const unsigned char> table, const std::array<unsigned char, 16>& perBitsCount, bool writeMarkers = false, unsigned short sectionSize = 0u) ;

			// Parsing
			static void parseFromMarker (const unsigned char* data, std::vector<JpgHuffmanTable>& output) ;

		public :

			// Attributes
			nkMemory::BufferView<const unsigned char> _table ;
			unsigned char _perBitsCounts [16] = {0u} ;
			unsigned char _smallestSymbolBits = 0 ;
			unsigned char _biggestSymbolBits = 0 ;
	} ;
}